package com.androidbook.simplelivefolder;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.provider.LiveFolders;

public class SimpleLiveFolderCreateActivity extends Activity {
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        final Intent intent = getIntent();
        final String action = intent.getAction();
        if (LiveFolders.ACTION_CREATE_LIVE_FOLDER.equals(action)) {
            final Intent baseIntent =
                new Intent(Intent.ACTION_VIEW, SimpleFieldnotesContentProvider.CONTENT_URI);
            final Intent resultIntent = new Intent();
            resultIntent.setData(SimpleFieldnotesContentProvider.LIVE_URI);
            resultIntent.putExtra(LiveFolders.EXTRA_LIVE_FOLDER_NAME,
                getResources().getString(R.string.livefolder_label));
            resultIntent.putExtra(LiveFolders.EXTRA_LIVE_FOLDER_ICON,
                Intent.ShortcutIconResource.fromContext(this, R.drawable.foldericon));
            resultIntent.putExtra(LiveFolders.EXTRA_LIVE_FOLDER_DISPLAY_MODE,
                LiveFolders.DISPLAY_MODE_LIST);
            resultIntent.putExtra(LiveFolders.EXTRA_LIVE_FOLDER_BASE_INTENT,
                baseIntent);
            setResult(RESULT_OK, resultIntent);
        } else {
            setResult(RESULT_CANCELED);
        }
        finish();
    }
}
